/*Soubor tree.cpp pro Stargate Script

Zde najdeme definici funkci ktere jsou pouzity pro vytvoreni AST stromu skriptu,
o volani funkci se stara parser vytvoreni pomoci utility bison

Vsechny funkce delaji to same, vytvori prislusnou novou strukturu, inicilizuji jeji
cleny zadanymi parametry a vrati ukazatel na vytvorenou novou strukturu
To plati i funkcich nad strukturou CODE
*/
#include "stdafx.h"
#include "common.h"
#include "tree.h"
#include "error.h"
#include <stdlib.h>
#include "asmutils.h"

SCRIPT*		makeSCRIPT(TOPLEVEL* toplevels)
{
	SCRIPT*	pScript = new SCRIPT;
	pScript->line_number = line_number;
	pScript->toplevels = toplevels;
	pScript->symbolTable = NULL;
	return pScript;
}

TOPLEVEL*	makeTOPLEVELfunction(FUNCTION* function)
{
	TOPLEVEL* pTopLevel = new TOPLEVEL;
	pTopLevel->line_number = line_number;
	pTopLevel->function = function;
	pTopLevel->next = NULL;
	return pTopLevel;
}

FUNCTION*	makeFUNCTION(char* name,DECLARATION* declaration,STATEMENT* statements)
{
	FUNCTION* pFunction = new FUNCTION;

	pFunction->kind = localT;
	pFunction->line_number = line_number;
	pFunction->name = name;
	pFunction->signature = NULL;
	pFunction->declaration = declaration;
	pFunction->statements = statements;
	pFunction->symbolTable = NULL;
	pFunction->opcodes = NULL;
	pFunction->labels = NULL;
	pFunction->library = NULL;
	pFunction->labelCount = 0;
	pFunction->type = NULL;

	return pFunction;
}

FUNCTION*	makeFUNCTIONextern(char* library,TYPE* type,char* name,int params)
{
	FUNCTION* pFunction = new FUNCTION;
	char	buffer[128];

	_itoa(params,buffer,10);

	pFunction->kind = externT;
	pFunction->line_number = line_number;
	pFunction->name = name;
	pFunction->signature = stringConcat(name,"(",buffer,")",NULL);
	pFunction->declaration = NULL;
	pFunction->statements = NULL;
	pFunction->symbolTable = NULL;
	pFunction->opcodes = NULL;
	pFunction->labels = NULL;
	pFunction->library = library;
	pFunction->type = type;
	pFunction->labelCount = 0;

	return pFunction;
}

TYPE*	makeTYPEvoid()
{
	TYPE* pType = new TYPE;
	pType->line_number = line_number;
	pType->kind = voidT;
	return pType;
}

TYPE*	makeTYPEint()
{
	TYPE* pType = new TYPE;
	pType->line_number = line_number;
	pType->kind = intT;
	return pType;
}

TYPE*	makeTYPEstring()
{
	TYPE* pType = new TYPE;
	pType->line_number = line_number;
	pType->kind = stringT;
	return pType;
}

TYPE*	makeTYPEdouble()
{
	TYPE* pType = new TYPE;
	pType->line_number = line_number;
	pType->kind = doubleT;
	return pType;
}


DECLARATION*	makeDECLARATIONformal(char* name)
{
	DECLARATION* pDeclaration = new DECLARATION;
	pDeclaration->line_number = line_number;
	pDeclaration->kind = formalT;
	//u parametru funkce nezjistime jaky typ to je, takze zachetujeme a nastavime vsechny typy
	//na int a pak se bude pretypovavat
	pDeclaration->val.formalD.name = name;
	pDeclaration->next = NULL;

	return pDeclaration;
}

DECLARATION*	makeDECLARATIONvariable(IDENTIFIER* identifiers, EXPRESSION* initialization)
{
	DECLARATION* pDeclaration = new DECLARATION;
	pDeclaration->line_number = line_number;
	pDeclaration->kind = variableT;
	pDeclaration->next = NULL;
	pDeclaration->val.variableD.identifiers = identifiers;
	pDeclaration->val.variableD.initialization = initialization;
	//pDeclaration->val.variableD.modifier = modifier;
	
	return pDeclaration;
}

DECLARATION*	makeDECLARATIONsimplevar(char* name, EXPRESSION* initialization)
{
	DECLARATION* pDeclaration = new DECLARATION;
	pDeclaration->line_number = line_number;
	pDeclaration->kind = simplevarT;
	pDeclaration->next = NULL;
	pDeclaration->val.simplevarD.name = name;
	pDeclaration->val.simplevarD.initialization = initialization;

	return pDeclaration;
}

FORINIT*		makeFORINITdeclaration(DECLARATION* declaration)
{
	FORINIT* pForInit = new FORINIT;
	pForInit->line_number = line_number;
	pForInit->kind = declarationforinitT;
	pForInit->next = NULL;
	pForInit->val.declarationF = declaration;

	return pForInit;
}

FORINIT*		makeFORINITexpression(EXPRESSION* expression)
{
	FORINIT* pForInit = new FORINIT;
	pForInit->line_number = line_number;
	pForInit->kind = expressionforinitT;
	pForInit->next = NULL;
	pForInit->val.expressionF = expression;

	return pForInit;
}

STATEMENT*	makeSTATEMENTskip()
{
	STATEMENT* pStatement = new STATEMENT;
	pStatement->kind = skipT;
	pStatement->line_number = line_number;
	
	return pStatement;
}

STATEMENT*	makeSTATEMENTdeclaration(DECLARATION* declaration)
{
	STATEMENT* pStatement = new STATEMENT;
	pStatement->kind = declstmT;
	pStatement->line_number = line_number;
	pStatement->val.declaration = declaration;

	return pStatement;
}

STATEMENT*	makeSTATEMENTexpression(EXPRESSION* expression)
{
	STATEMENT* pStatement = new STATEMENT;
	pStatement->line_number = line_number;
	pStatement->kind = expT;
	pStatement->val.expression = expression;

	return pStatement;
}

STATEMENT*	makeSTATEMENTreturn(EXPRESSION* expression)
{
	STATEMENT* pStatement = new STATEMENT;
	pStatement->kind = returnT;
	pStatement->line_number = line_number;
	pStatement->val.returnS.expression = expression;

	return pStatement;
}

STATEMENT*	makeSTATEMENTif(EXPRESSION* condition, STATEMENT* body)
{
	STATEMENT* pStatement = new STATEMENT;
	pStatement->line_number = line_number;
	pStatement->kind = ifT;
	pStatement->val.ifS.condition = condition;
	pStatement->val.ifS.body = body;

	return pStatement;
}

STATEMENT*	makeSTATEMENTifelse(EXPRESSION* condition, STATEMENT* ifpart, STATEMENT* elsepart)
{
	STATEMENT* pStatement = new STATEMENT;
	pStatement->line_number = line_number;
	pStatement->kind = ifelseT;
	pStatement->val.ifelseS.condition = condition;
	pStatement->val.ifelseS.ifbody = ifpart;
	pStatement->val.ifelseS.elsebody = elsepart;

	return pStatement;
}

STATEMENT*	makeSTATEMENTwhile(EXPRESSION* condition,STATEMENT* body)
{
	STATEMENT* pStatement = new STATEMENT;
	pStatement->line_number = line_number;
	pStatement->kind = whileT;
	pStatement->val.whileS.condition = condition;
	pStatement->val.whileS.body = body;

	return pStatement;
}

STATEMENT*	makeSTATEMENTfor(FORINIT* inits,EXPRESSION* condition,EXPRESSION* updates,STATEMENT* body)
{
	STATEMENT* pStatement = new STATEMENT;
	pStatement->line_number = line_number;
    pStatement->kind = forT;
	pStatement->val.forS.condition = condition;
	pStatement->val.forS.inits = inits;
	pStatement->val.forS.updates = updates;
	pStatement->val.forS.body = body;

	return pStatement;
}

STATEMENT*	makeSTATEMENTsequence(STATEMENT* firts, STATEMENT* second)
{
	STATEMENT* pStatement = new STATEMENT;
	pStatement->line_number = line_number;
	pStatement->kind = sequenceT;
    pStatement->val.sequenceS.firts = firts;
	pStatement->val.sequenceS.second = second;

	return pStatement;
}

STATEMENT*	makeSTATEMENTscope(STATEMENT* statement)
{
	STATEMENT* pStatement = new STATEMENT;
	pStatement->line_number = line_number;
	pStatement->kind = scopeT;
	pStatement->val.scopeS.statement = statement;

	return pStatement;
}

IDENTIFIER*	makeIDENTIFIER(char* name)
{
	IDENTIFIER* pIdentifier = new IDENTIFIER;
	pIdentifier->line_number = line_number;
	pIdentifier->name = name;
	pIdentifier->next = NULL;

	return pIdentifier;
}

EXPRESSION*	makeEXPRESSIONintconst(int value)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = intconstT;
	pExpression->next = NULL;
	pExpression->val.intconstE = value;

	return pExpression;
}


EXPRESSION* makeEXPRESSIONstringconst(char* value)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = stringconstT;
	pExpression->next = NULL;
	pExpression->val.stringconstE = value;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONdoubleconst(double value)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = doubleconstT;
	pExpression->next = NULL;
	pExpression->val.doubleconstE = value;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONuminus(EXPRESSION* expression)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = uminusT;
	pExpression->next = NULL;
	pExpression->val.uminusE = expression;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONnot(EXPRESSION* expression)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = notT;
	pExpression->next = NULL;
	pExpression->val.notE.expression = expression;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONlvalue(LVALUE* lvalue)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = lvalueT;
	pExpression->next = NULL;
	pExpression->val.lvalue = lvalue;

	return pExpression;
}

EXPRESSION* makeEXPRESSIONassignment(LVALUE* lvalue, EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = assignmentT;
	pExpression->next = NULL;
	pExpression->val.assignmentE.left = lvalue;
	pExpression->val.assignmentE.right = right;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONplusassign(LVALUE* lvalue,EXPRESSION* right)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = plusassignT;
	pExpression->next = NULL;
	pExpression->val.plusassignE.left = lvalue;
	pExpression->val.plusassignE.right = right;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONminusassign(LVALUE* lvalue,EXPRESSION* right)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = minusassignT;
	pExpression->next = NULL;
	pExpression->val.minusassignE.left = lvalue;
	pExpression->val.minusassignE.right = right;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONmulassign(LVALUE* lvalue,EXPRESSION* right)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = mulassignT;
	pExpression->next = NULL;
	pExpression->val.mulassignE.left = lvalue;
	pExpression->val.mulassignE.right = right;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONdivassign(LVALUE* lvalue,EXPRESSION* right)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = divassignT;
	pExpression->next = NULL;
	pExpression->val.divassignE.left = lvalue;
	pExpression->val.divassignE.right = right;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONmodassign(LVALUE* lvalue,EXPRESSION* right)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = modassignT;
	pExpression->next = NULL;
	pExpression->val.modassignE.left = lvalue;
	pExpression->val.modassignE.right = right;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONshlassign(LVALUE*	lvalue,EXPRESSION* right)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = shlassignT;
	pExpression->next = NULL;
	pExpression->val.shlassignE.left = lvalue;
	pExpression->val.shlassignE.right = right;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONshrassign(LVALUE* lvalue,EXPRESSION* right)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = shrassignT;
	pExpression->next = NULL;
	pExpression->val.shrassignE.left = lvalue;
	pExpression->val.shrassignE.right = right;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONandassign(LVALUE* lvalue,EXPRESSION* right)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = andassignT;
	pExpression->next = NULL;
	pExpression->val.andassignE.left = lvalue;
	pExpression->val.andassignE.right = right;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONorassign(LVALUE*	lvalue,EXPRESSION* right)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = orassignT;
	pExpression->next = NULL;
	pExpression->val.orassignE.left = lvalue;
	pExpression->val.orassignE.right = right;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONshl(EXPRESSION* left,EXPRESSION* right)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = shlT;
	pExpression->next = NULL;
	pExpression->val.shlE.left = left;
	pExpression->val.shlE.right = right;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONshr(EXPRESSION* left,EXPRESSION* right)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = shrT;
	pExpression->next = NULL;
	pExpression->val.shrE.left = left;
	pExpression->val.shrE.right = right;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONpostinc(LVALUE* lvalue)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = postincT;
	pExpression->next = NULL;
	pExpression->val.incE = lvalue;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONprefinc(LVALUE* lvalue)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = prefincT;
	pExpression->next = NULL;
	pExpression->val.incE = lvalue;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONpostdec(LVALUE* lvalue)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = postdecT;
	pExpression->next = NULL;
	pExpression->val.decE = lvalue;

	return pExpression;
}

EXPRESSION*					makeEXPRESSIONprefdec(LVALUE* lvalue)
{
	EXPRESSION*	pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = prefdecT;
	pExpression->next = NULL;
	pExpression->val.decE = lvalue;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONequals(EXPRESSION* left,EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = equalsT;
	pExpression->next = NULL;
	pExpression->val.equalsE.left = left;
	pExpression->val.equalsE.right = right;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONnequals(EXPRESSION* left,EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = nequalsT;
	pExpression->next = NULL;
	pExpression->val.nequalsE.left = left;
	pExpression->val.nequalsE.right = right;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONless(EXPRESSION* left,EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = lessT;
	pExpression->next = NULL;
	pExpression->val.lessE.left = left;
	pExpression->val.lessE.right = right;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONgreater(EXPRESSION* left,EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = greaterT;
	pExpression->next = NULL;
	pExpression->val.greaterE.left = left;
	pExpression->val.greaterE.right = right;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONlequals(EXPRESSION* left,EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = lequalsT;
	pExpression->next = NULL;
	pExpression->val.lequalsE.left = left;
	pExpression->val.lequalsE.right = right;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONgequals(EXPRESSION* left,EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = gequalsT;
	pExpression->next = NULL;
	pExpression->val.gequalsE.left = left;
	pExpression->val.gequalsE.right = right;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONplus(EXPRESSION* left, EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = plusT;
	pExpression->next = NULL;
	pExpression->val.plusE.left = left;
	pExpression->val.plusE.right = right;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONminus(EXPRESSION* left, EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = minusT;
	pExpression->next = NULL;
	pExpression->val.minusE.left = left;
	pExpression->val.minusE.right = right;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONmul(EXPRESSION* left, EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = mulT;
	pExpression->next = NULL;
	pExpression->val.mulE.left = left;
	pExpression->val.mulE.right = right;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONdiv(EXPRESSION* left, EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = divT;
	pExpression->next = NULL;
	pExpression->val.divE.left = left;
	pExpression->val.divE.right = right;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONmod(EXPRESSION* left,EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = modT;
	pExpression->next = NULL;
	pExpression->val.modE.left = left;
	pExpression->val.modE.right = right;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONand(EXPRESSION* left, EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = andT;
	pExpression->next = NULL;
	pExpression->val.andE.left = left;
	pExpression->val.andE.right = right;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONor(EXPRESSION* left, EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = orT;
	pExpression->next = NULL;
	pExpression->val.orE.left = left;
	pExpression->val.orE.right = right;

	return pExpression;
}

EXPRESSION* makeEXPRESSIONcall(char* name,EXPRESSION* arguments)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = callT;
	pExpression->next = NULL;
	pExpression->val.callE.name = name;
	pExpression->val.callE.arguments = arguments;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONbitand(EXPRESSION* left,EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = bitandT;
	pExpression->next = NULL;
	pExpression->val.orE.left = left;
	pExpression->val.orE.right = right;

	return pExpression;
}

EXPRESSION*	makeEXPRESSIONbitor(EXPRESSION* left,EXPRESSION* right)
{
	EXPRESSION* pExpression = new EXPRESSION;
	pExpression->line_number = line_number;
	pExpression->kind = bitorT;
	pExpression->next = NULL;
	pExpression->val.orE.left = left;
	pExpression->val.orE.right = right;

	return pExpression;
}

LVALUE*	makeLVALUEidentifier(char* identifier)
{
	LVALUE* pLvalue = new LVALUE;
	pLvalue->line_number = line_number;
	pLvalue->kind = identifierT;
	pLvalue->val.idL = identifier;

	return pLvalue;
}

/*************************************CInstruction******************************************************************/
CInstruction* CInstruction::nop(CInstruction* next)
{
	this->kind = nopCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::mul(CInstruction* next)
{
	this->kind = mulCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::neg(CInstruction* next)
{
	this->kind = negCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::mod(CInstruction* next)
{
	this->kind = modCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::sub(CInstruction* next)
{
	this->kind = subCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::div(CInstruction* next)
{
	this->kind = divCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::add(CInstruction* next)
{
	this->kind = addCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::label(int label, CInstruction* next)
{
	this->kind = labelCK;
	this->visited = 0;
	this->next = next;
	this->val.labelC = label;

	return this;
}

CInstruction* CInstruction::lgoto(int label, CInstruction* next)
{
	this->kind = lgotoCK;
	this->visited = 0;
	this->next = next;
	this->val.gotoC = label;

	return this;
}

CInstruction* CInstruction::ifeq(int label, CInstruction* next)
{
	this->kind = ifeqCK;
	this->visited = 0;
	this->next = next;
	this->val.ifeqC = label;

	return this;
}

CInstruction* CInstruction::ifne(int label, CInstruction* next)
{
	this->kind = ifneCK;
	this->visited = 0;
	this->next = next;
	this->val.ifneC = label;

	return this;
}

CInstruction* CInstruction::if_cmpeq(int label, CInstruction* next)
{
	this->kind = if_cmpeqCK;
	this->visited = 0;
	this->next = next;
	this->val.if_cmpeqC = label;

	return this;
}

CInstruction* CInstruction::if_cmpgt(int label, CInstruction* next)
{
	this->kind = if_cmpgtCK;
	this->visited = 0;
	this->next = next;
	this->val.if_cmpgtC = label;

	return this;
}

CInstruction* CInstruction::if_cmplt(int label, CInstruction* next)
{
	this->kind = if_cmpltCK;
	this->visited = 0;
	this->next = next;
	this->val.if_cmpltC = label;

	return this;
}

CInstruction* CInstruction::if_cmple(int label, CInstruction* next)
{
	this->kind = if_cmpleCK;
	this->visited = 0;
	this->next = next;
	this->val.if_cmpleC = label;

	return this;
}

CInstruction* CInstruction::if_cmpge(int label, CInstruction* next)
{	
	this->kind = if_cmpgeCK;
	this->visited = 0;
	this->next = next;
	this->val.if_cmpgeC = label;

	return this;
}

CInstruction* CInstruction::if_cmpne(int label, CInstruction* next)
{
	this->kind = if_cmpneCK;
	this->visited = 0;
	this->next = next;
	this->val.if_cmpneC = label;

	return this;
}

CInstruction* CInstruction::nreturn(CInstruction* next)
{
	this->kind = nreturnCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::vreturn(CInstruction* next)
{
	this->kind = vreturnCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::load(int arg, CInstruction* next)
{
	this->kind = loadCK;
	this->visited = 0;
	this->next = next;
	this->val.loadC = arg;

	return this;
}

CInstruction* CInstruction::store(int arg, CInstruction* next)
{
	this->kind = storeCK;
	this->visited = 0;
	this->next = next;
	this->val.storeC = arg;

	return this;
}

CInstruction* CInstruction::dup(CInstruction* next)
{
	this->kind = dupCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::pop(CInstruction* next)
{
	this->kind = popCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::ldc_int(int arg, CInstruction* next)
{
	this->kind = ldc_intCK;
	this->visited = 0;
	this->next = next;
	this->val.ldc_intC = arg;

	return this;
}

CInstruction* CInstruction::ldc_string(char* arg, CInstruction* next)
{
	this->kind = ldc_stringCK;
	this->visited = 0;
	this->next = next;
	this->val.ldc_stringC = arg;

	return this;
}

CInstruction* CInstruction::ldc_double(double arg, CInstruction* next)
{
	this->kind = ldc_doubleCK;
	this->visited = 0;
	this->next = next;
	this->val.ldc_doubleC = arg;

	return this;
}

CInstruction* CInstruction::lcall(FUNCTION* arg, CInstruction* next)
{
	this->kind = lcallCK;
	this->visited = 0;
	this->next = next;
	this->val.lcallC = arg;

	return this;
}

CInstruction* CInstruction::ecall(FUNCTION* arg,int args,CInstruction* next)
{
	this->kind = ecallCK;
	this->visited = 0;
	this->next = next;
	this->val.ecallC.function = arg;
	this->val.ecallC.arguments = args;

	return this;
}

CInstruction* CInstruction::shl(CInstruction* next)
{
	this->kind = shlCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::shr(CInstruction* next)
{
	this->kind = shrCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::inc(CInstruction* next)
{
	this->kind = incCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::dec(CInstruction* next)
{
	this->kind = decCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::and(CInstruction* next)
{
	this->kind = andCK;
	this->visited = 0;
	this->next = next;

	return this;
}

CInstruction* CInstruction::or(CInstruction* next)
{
	this->kind = orCK;
	this->visited = 0;
	this->next = next;

	return this;
}